//Lab 04. Plot amplitude and phase versus describing function of realy with hysterisis nonlinearity 

//scilab - 6.0.0
// Operating System : Windows 10, 64-bit

//------------------------------------------------------------------
close;
clc;
clear;
//------------------------------------------------------------------
//Response of the Relay with hysteresis nonlinearity to sinusoidal input
figure;
importXcosDiagram(".\Lab04_DF_RelayNHyst_Model.xcos")
xcos_simulate(scs_m,4);
scs_m.props.context
plot(yt.time,yt.values(:,1),'r--','thickness',2)
plot(yt.time,yt.values(:,2),'b','thickness',2)

xlabel('Time (sec.)','fontsize',2);
ylabel('Amplitude','fontsize',2);
title("Relay with hysteresis nonlinearity output to sinusoidal input",'fontsize',4);
exec .\figure_properties.sci; //custom script for setting figure properties
zoom_rect([0 -1.2 5 1.2])
//------------------------------------------------------------------
////Describing Functin for relay with hysteresis nonlinearity.
h=0.1;
N=1;
i=1;

for a=0.1:0.025:1
    if a<h then
        Keq(i,1)=0;
        ro(i,1)=0;
        theta(i,1)=0
    else
        Keq(i,1)=4*N/(%pi*a)*(sqrt(1-(h/a)^2)-%i*h/a)
        [r th]=polar(Keq(i,1));
        ro(i,1)=r; //magnitude
        theta(i,1)=clean(th); //angle in radians
    end
    i=i+1;
end

a=0.1:0.025:1
a=a';
figure,

subplot(2,1,1), plot(a,ro,'thickness',2)
xlabel('$a$','fontsize',2);
ylabel(['Magnitude', '$|K_{eq}|$'],'fontsize',2);

xset('font size',2);
exec .\figure_properties.sci; //custom script for setting figure properties
title("Describing Functin for relay with hysteresis nonlinearity with h=0.1 and N=1",'fontsize',4);

subplot(2,1,2), plot(a,theta*180/%pi,'thickness',2)
xlabel('$a$');
ylabel(['Phase', '$ \angle K_{eq}$','deg.']);
xset('font size',2);
exec .\figure_properties.sci; //custom script for setting figure properties
//------------------------------------------------------------------
